using System;
using System.Collections.Generic;
using System.Globalization;

class NovaGodina
{
    static int n;
    static double epsilon;
    static double[] x, y;
    static List<int>[] mstAdj;
    
    static double ManhattanDist(int i, int j)
    {
        return Math.Abs(x[i] - x[j]) + Math.Abs(y[i] - y[j]);
    }
    
    static void ComputeMST()
    {
        mstAdj = new List<int>[n];
        for (int i = 0; i < n; i++)
            mstAdj[i] = new List<int>();
        
        bool[] inMST = new bool[n];
        double[] minDist = new double[n];
        int[] parent = new int[n];
        
        for (int i = 0; i < n; i++)
        {
            minDist[i] = double.MaxValue;
            parent[i] = -1;
        }
        minDist[0] = 0;
        
        for (int iter = 0; iter < n; iter++)
        {
            int u = -1;
            double best = double.MaxValue;
            for (int i = 0; i < n; i++)
            {
                if (!inMST[i] && minDist[i] < best)
                {
                    best = minDist[i];
                    u = i;
                }
            }
            
            if (u == -1) break;
            inMST[u] = true;
            
            if (parent[u] != -1)
            {
                mstAdj[u].Add(parent[u]);
                mstAdj[parent[u]].Add(u);
            }
            
            for (int v = 0; v < n; v++)
            {
                if (!inMST[v])
                {
                    double dist = ManhattanDist(u, v);
                    if (dist < minDist[v])
                    {
                        minDist[v] = dist;
                        parent[v] = u;
                    }
                }
            }
        }
    }
    
    static void Main()
    {
        string[] firstLine = Console.ReadLine().Split(new char[] { ' ', '\t' }, StringSplitOptions.RemoveEmptyEntries);
        n = int.Parse(firstLine[0]);
        epsilon = double.Parse(firstLine[1], CultureInfo.InvariantCulture);
        
        x = new double[n];
        y = new double[n];
        
        for (int i = 0; i < n; i++)
        {
            string[] coords = Console.ReadLine().Split(new char[] { ' ', '\t' }, StringSplitOptions.RemoveEmptyEntries);
            x[i] = double.Parse(coords[0], CultureInfo.InvariantCulture);
            y[i] = double.Parse(coords[1], CultureInfo.InvariantCulture);
        }
        
        ComputeMST();
        
        double sampleDist = epsilon / 2.0;
        
        // Iterative DFS with explicit stack to avoid stack overflow
        // State: (node, childIndex, lastSelected, distFromLast, phase)
        // phase: 0 = first visit, 1 = after children
        
        List<int> Q = new List<int>();
        List<(int, int)> T = new List<(int, int)>();
        bool[] inQ = new bool[n];
        bool[] visited = new bool[n];
        int[] mstParent = new int[n];
        for (int i = 0; i < n; i++) mstParent[i] = -1;
        
        // First, compute parent pointers in MST (rooted at 0)
        Queue<int> bfs = new Queue<int>();
        bfs.Enqueue(0);
        visited[0] = true;
        while (bfs.Count > 0)
        {
            int u = bfs.Dequeue();
            foreach (int v in mstAdj[u])
            {
                if (!visited[v])
                {
                    visited[v] = true;
                    mstParent[v] = u;
                    bfs.Enqueue(v);
                }
            }
        }
        
        // Reset visited
        for (int i = 0; i < n; i++) visited[i] = false;
        
        // Compute children for each node
        List<int>[] children = new List<int>[n];
        for (int i = 0; i < n; i++)
            children[i] = new List<int>();
        
        for (int i = 1; i < n; i++)
        {
            if (mstParent[i] != -1)
            {
                children[mstParent[i]].Add(i);
            }
        }
        
        // DFS with explicit state
        // Each node: when we visit, decide to select or not, then recurse to children
        // After all children done, possibly update state
        
        // lastSelectedOnPath[u] = the last selected vertex on path from root to u
        int[] lastSelectedOnPath = new int[n];
        double[] distFromLastOnPath = new double[n];
        
        // Process nodes in BFS order but with DFS logic
        // Actually, let's use iterative DFS properly
        
        Stack<(int node, int childIdx)> stack = new Stack<(int, int)>();
        stack.Push((0, 0));
        lastSelectedOnPath[0] = -1;
        distFromLastOnPath[0] = 0;
        
        while (stack.Count > 0)
        {
            var (u, childIdx) = stack.Pop();
            
            if (childIdx == 0)
            {
                // First visit to u
                visited[u] = true;
                
                int lastSel = lastSelectedOnPath[u];
                double dist = distFromLastOnPath[u];
                
                // If u has a parent, add edge distance
                if (mstParent[u] != -1)
                {
                    lastSel = lastSelectedOnPath[mstParent[u]];
                    dist = distFromLastOnPath[mstParent[u]] + ManhattanDist(mstParent[u], u);
                    lastSelectedOnPath[u] = lastSel;
                    distFromLastOnPath[u] = dist;
                }
                
                bool isLeaf = children[u].Count == 0;
                bool isBranch = children[u].Count > 1;
                bool isFirst = Q.Count == 0;
                bool farEnough = dist >= sampleDist;
                
                bool select = isFirst || isLeaf || isBranch || farEnough;
                
                if (select && !inQ[u])
                {
                    Q.Add(u);
                    inQ[u] = true;
                    
                    if (lastSel != -1)
                    {
                        T.Add((lastSel, u));
                    }
                    
                    lastSelectedOnPath[u] = u;
                    distFromLastOnPath[u] = 0;
                }
            }
            
            if (childIdx < children[u].Count)
            {
                int v = children[u][childIdx];
                
                // Push current node with next child index
                stack.Push((u, childIdx + 1));
                
                // Propagate state to child
                lastSelectedOnPath[v] = lastSelectedOnPath[u];
                distFromLastOnPath[v] = distFromLastOnPath[u] + ManhattanDist(u, v);
                
                // Push child for processing
                stack.Push((v, 0));
            }
        }
        
        // Create mapping from vertex to position in Q (1-based)
        Dictionary<int, int> qIndex = new Dictionary<int, int>();
        for (int i = 0; i < Q.Count; i++)
        {
            qIndex[Q[i]] = i + 1;
        }
        
        // Output
        Console.WriteLine(Q.Count);
        
        List<string> qOut = new List<string>();
        foreach (int v in Q)
        {
            qOut.Add((v + 1).ToString());
        }
        Console.WriteLine(string.Join(" ", qOut));
        
        foreach (var (a, b) in T)
        {
            Console.WriteLine($"{qIndex[a]} {qIndex[b]}");
        }
    }
}